﻿<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'dbseoadmin');
define('IN_DBSEO', true);
define('DBSEO_ADMIN', true);
if ($_REQUEST['do'] != 'nav')
{
	define('VB_AREA', 'AdminCP');
}
define('VB_ENTRY', 1);
define('IN_CONTROL_PANEL', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'dbtech_dbseo', 'cpglobal', 'cphome', 'logging', 'threadmanage',
	'banning', 'cpuser', 'cpoption', 'cppermission', 'user'
);

// Step down a notch
chdir('./../');

// get special data templates from the datastore
require_once('./dbtech/dbseo/includes/specialtemplates.php');
$specialtemplates = $extracache;
$specialtemplates[] = 'pluginlistadmin';

// ######################### REQUIRE BACK-END ############################
require_once('global.php');
require_once(DIR . '/dbtech/dbseo/includes/functions.php');
require_once(DIR . '/includes/adminfunctions.php');

// ###################### Start headers (send no-cache) #######################
exec_nocache_headers();

if ($vbulletin->userinfo['cssprefs'] != '')
{
	$vbulletin->options['cpstylefolder'] = $vbulletin->userinfo['cssprefs'];
}

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/dbseo/includes/class_template.php');
}

if (!class_exists('DBSEO'))
{
	if (!$vbulletin->products['dbtech_dbseo'])
	{
		// This either wasn't installed or deactivated
		print_cp_message($vbphrase['dbtech_dbseo_deactivated']);
	}

	// Set important constants
	define('DBSEO_CWD', 	getcwd());
	define('DBSEO_TIMENOW', time());
	define('IN_DBSEO', 		true);

	// Make sure we nab this class
	include_once(DBSEO_CWD . '/dbtech/dbseo/includes/class_core.php');

	// Initialise our configuration
	DBSEO::init();
}

// ######################## CHECK ADMIN PERMISSIONS ######################
$needPassword = $authorised = false;
if (!($vbulletin->userinfo['permissions']['dbtech_dbseopermissions'] & $vbulletin->bf_ugp_dbtech_dbseopermissions['canadmindbseo']))
{
	if ($vbulletin->options['dbtech_dbseo_password'])
	{
		// We need a password
		$needPassword = true;
	}
}
else
{
	// We are authorised to be here
	$authorised = true;

	if (trim($vbulletin->options['dbtech_dbseo_password']) AND $vbulletin->options['dbtech_dbseo_password_mode'])
	{
		// We need a password
		$needPassword = true;

		// Lol nvm we aren't auth'd
		$authorised = false;
	}
}

if ($needPassword)
{
	$vbulletin->input->clean_array_gpc('p', array(
		'cppassword' => TYPE_STR,
	));
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'dbtseocppassword'      => TYPE_STR,
	));

	if ($vbulletin->GPC['cppassword'] == $vbulletin->options['dbtech_dbseo_password'])
	{
		// Valid password
		$vbulletin->GPC[COOKIE_PREFIX . 'dbtseocppassword'] = md5(md5(md5($vbulletin->options['dbtech_dbseo_password']) . md5(COOKIE_SALT)));
		vbsetcookie('dbtseocppassword', $vbulletin->GPC[COOKIE_PREFIX . 'dbtseocppassword']);
	}

	if (!$vbulletin->GPC[COOKIE_PREFIX . 'dbtseocppassword'] OR 
		$vbulletin->GPC[COOKIE_PREFIX . 'dbtseocppassword'] != md5(md5(md5($vbulletin->options['dbtech_dbseo_password']) . md5(COOKIE_SALT)))
	)
	{
		print_cp_header($vbphrase['dbtech_dbseo_welcome_to_the_admin_control_panel']);
		print_form_header('index', 'frames');
		print_table_header($vbphrase['password']);
		print_input_row($vbphrase['password'], 'cppassword');
		print_submit_row($vbphrase['submit'], 0);
		print_cp_footer();
	}
	else
	{
		// We've got a valid pass
		$authorised = true;
	}
}

if (!$authorised)
{
	print_cp_message($vbphrase['dbtech_dbseo_nopermission_cp']);
}

// ############################# LOG ACTION ##############################
if (empty($_REQUEST['do']))
{
	log_admin_action(iif($_REQUEST['action'] != '', 'action = ' . $_REQUEST['action']));
}

// #############################################################################

$vbulletin->input->clean_array_gpc('r', array(
	'redirect' => TYPE_STR,
	'nojs' 		=> TYPE_BOOL,
));

// #############################################################################
// ################################## REDIRECTOR ###############################
// #############################################################################

if (!empty($vbulletin->GPC['redirect']))
{
	require_once(DIR . '/includes/functions_login.php');
	$redirect = htmlspecialchars_uni(fetch_replaced_session_url($vbulletin->GPC['redirect']));
	$redirect = create_full_url($redirect);
	$redirect = preg_replace(
		array('/&#0*59;?/', '/&#x0*3B;?/i', '#;#'),
		'%3B',
		$redirect
	);
	$redirect = preg_replace('#&amp%3B#i', '&amp;', $redirect);

	print_cp_header($vbphrase['redirecting_please_wait'], '', "<meta http-equiv=\"Refresh\" content=\"0; URL=$redirect\" />");
	echo "<p>&nbsp;</p><blockquote><p>$vbphrase[redirecting_please_wait]</p></blockquote>";
	print_cp_footer();
	exit;
}

$vbulletin->input->clean_array_gpc('r', array(
	'file' 		=> TYPE_NOHTML
));

// #############################################################################
// ################################# SAVE NOTES ################################
// #############################################################################

if ($_POST['do'] == 'notes')
{
	$vbulletin->input->clean_array_gpc('p', array('notes' => TYPE_STR));

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "datastore
		SET data = " . $db->sql_prepare(htmlspecialchars_uni($vbulletin->GPC['notes'])) . "
		WHERE title = 'dbtech_dbseo_adminnote'
	");

	DBSEO::$cache['adminnote'] = htmlspecialchars_uni($vbulletin->GPC['notes']);
	$_REQUEST['do'] = 'home';
}

// #############################################################################
// ################################# HEADER FRAME ##############################
// #############################################################################

if ($_REQUEST['do'] == 'head')
{
	if (intval($vbulletin->versionnumber) > 3)
	{
		$stylevar['right'] = vB_Template_Runtime::fetchStyleVar('right');
		$stylevar['left'] = vB_Template_Runtime::fetchStyleVar('left');
	}
	
	ignore_user_abort(true);

	define('IS_NAV_PANEL', true);
	print_cp_header('', '');

	?>
	<table border="0" width="100%" height="100%">
	<tr align="center" valign="top">
		<td style="text-align:<?php echo $stylevar['left']; ?>"><a href="http://www.dragonbyte-tech.com/" target="_blank"><b><?php echo $vbphrase['admin_control_panel']; ?></b> (DragonByte Tech: DragonByte SEO v<?php echo DBSEO::$version; ?>)</a></td>
		<td><a href="http://www.dragonbyte-tech.com/" id="head_version_link" target="_blank">&nbsp;</a></td>
		<td style="white-space:nowrap; text-align:<?php echo $stylevar['right']; ?>; font-weight:bold">
			<a href="<?php echo $vbulletin->options['bburl'] . '/' . $vbulletin->options['forumhome']; ?>.php<?php echo $vbulletin->session->vars['sessionurl_q']; ?>" target="_blank"><?php echo $vbphrase['forum_home_page']; ?></a>
		</td>
	</tr>
	</table>
	<?php

	define('NO_CP_COPYRIGHT', true);
	unset($DEVDEBUG);
	print_cp_footer();

}

// ################################ NAVIGATION FRAME #############################

if ($_REQUEST['do'] == 'nav')
{
	require_once(DIR . '/includes/adminfunctions_navpanel.php');
	print_cp_header();

	echo "\n<div>";
	?><img src="../cpstyles/<?php echo $vbulletin->options['cpstylefolder']; ?>/cp_logo.gif" title="<?php echo $vbphrase['admin_control_panel']; ?>" alt="" border="0" hspace="4" vspace="4" /><?php
	echo "</div>\n\n<div style=\"width:168px; padding: 4px\">\n";

	// cache nav prefs
	can_administer();
	construct_nav_spacer();

	echo "<div align=\"center\"><a href=\"index.php?" . $vbulletin->session->vars['sessionurl'] . "do=home\">$vbphrase[control_panel_home]</a></div>";
	echo "<div align=\"center\"><a href=\"../" . $vbulletin->config['Misc']['admincpdir'] . "\">$vbphrase[dbtech_dbseo_vbulletin_admin_control_panel]</a></div>";
	
	// Include navigation
	require(DIR . '/dbtech/dbseo/includes/cpnav.php');
	
	echo $_NAV;
	
	echo "</div>\n";
	// *************************************************

	define('NO_CP_COPYRIGHT', true);
	unset($DEVDEBUG);
	print_cp_footer();

}

// #############################################################################
// ################################ BUILD FRAMESET #############################
// #############################################################################

if ($_REQUEST['do'] == 'frames' OR empty($_REQUEST['do']))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'loc' 		=> TYPE_NOHTML
	));

	if (!empty($vbulletin->GPC['loc']))
	{
		// Strip invalid characters
		$action = preg_replace("/[^a-zA-Z0-9-_]/", "", $vbulletin->GPC['loc']);

		if (!file_exists(DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php'))
		{
			if (!file_exists(DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php'))
			{
				// Throw error from invalid action
				print_cp_message(
					$vbphrase['dbtech_dbseo_invalid_action'] . '<br />
					<strong>Not Found:</strong> <em>' . DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php' . '</em><br />' . '
					<strong>Not Found:</strong> <em>' . DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php' . '</em>'
				);
			}
			else
			{
				// Include the selected file
				$loc = DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php';
			}
		}
		else
		{
			// Include the selected file
			$loc = DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php';
		}

	}

	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en">
	<head>
	<script type="text/javascript">
	<!--
	// get out of any containing frameset
	if (self.parent.frames.length != 0)
	{
		self.parent.location.replace(document.location.href);
	}
	// -->
	</script>
	<title><?php echo $vbulletin->options['bbtitle'] . ' ' . $vbphrase['admin_control_panel']; ?></title>
	</head>

        <frameset cols="195,*"  framespacing="0" border="0" frameborder="0">
            <frame src="index.php?<?php echo $vbulletin->session->vars['sessionurl']; ?>do=nav<?php echo iif($vbulletin->GPC['nojs'], '&amp;nojs=1'); ?>" name="nav" scrolling="yes" frameborder="0" marginwidth="0" marginheight="0" border="no" />
            <frameset rows="20,*"  framespacing="0" border="0" frameborder="0">
                <frame src="index.php?<?php echo $vbulletin->session->vars['sessionurl']; ?>do=head" name="head" scrolling="no" noresize="noresize" frameborder="0" marginwidth="10" marginheight="0" border="no" />
                <frame src="<?php echo iif(!empty($vbulletin->GPC['loc']), $loc, "index.php?" . $vbulletin->session->vars['sessionurl'] . "do=home"); ?>" name="main" scrolling="yes" frameborder="0" marginwidth="10" marginheight="10" border="no" />
           </frameset>
      	</frameset>

	<noframes>
		<body>
			<p><?php echo $vbphrase['no_frames_support']; ?></p>
		</body>
	</noframes>
	</html>
	<?php
	die();
}

// ################################ MAIN FRAME #############################

if ($_REQUEST['do'] == 'home')
{

	print_cp_header($vbphrase['dbtech_dbseo_welcome_to_the_admin_control_panel']);

	if (
		$vbulletin->config['Datastore']['class'] == 'vB_Datastore_XCache' AND 
		@ini_get('xcache.admin.enable_auth') == 'On' AND (
			!$vbulletin->config['xcache']['user'] OR
			!$vbulletin->config['xcache']['pass']
		)
	)
	{
		// *************************************
		// XCache warning
		
		print_table_start();
		print_table_header($vbphrase['dbtech_dbseo_xcache_auth'], 1);
		print_description_row($vbphrase['dbtech_dbseo_xcache_auth_descr']);
		print_table_footer();
	}

	// *************************************
	// Administrator Notes
	
	print_form_header('index', 'notes');
	print_table_header($vbphrase['administrator_notes'], 1);
	print_description_row("<textarea name=\"notes\" style=\"width: 90%\" rows=\"9\" tabindex=\"1\">" . DBSEO::$cache['adminnote'] . "</textarea>", false, 1, '', 'center');
	print_submit_row($vbphrase['save'], 0, 1);

	// *************************************
	// Credits
	print_table_start();
	print_table_header($vbphrase['dbtech_dbseo_developers_and_contributors']);
	print_column_style_code(array('white-space: nowrap', ''));
	print_label_row('<b>' . 'NULLED by' . '</b>', '
		<a href="https://twitter.com/nazooof" target="dbtech">nazooof</a>
	', '', 'top', NULL, false);
	print_label_row('<b>' . $vbphrase['dbtech_dbseo_business_product_development'] . '</b>', '
		<a href="http://www.dragonbyte-tech.com/member.ph' . 'p?u=3" target="dbtech">Iain Kidd</a>, 
		<a href="http://www.seovb.com" target="seovb">SEOvB</a>
	', '', 'top', NULL, false);
	print_label_row('<b>' . $vbphrase['dbtech_dbseo_engineering'] . '</b>', '
		<a href="http://www.dragonbyte-tech.com/member.ph' . 'p?u=1" target="dbtech">Fillip Hannisdal</a>, 
		<a href="http://www.seovb.com" target="seovb">SEOvB</a>
	', '', 'top', NULL, false);
	print_label_row('<b>' . $vbphrase['dbtech_dbseo_qa'] . '</b>', '
		<a href="http://www.dragonbyte-tech.com/member.ph' . 'p?u=1" target="dbtech">Fillip Hannisdal</a>, 
		<a href="http://www.dragonbyte-tech.com/member.ph' . 'p?u=3" target="dbtech">Iain Kidd</a>, 
		<a href="http://www.seovb.com" target="seovb">SEOvB</a>
	', '', 'top', NULL, false);
	
	print_label_row('<b>' . $vbphrase['dbtech_dbseo_support'] . '</b>', '
		<a href="http://www.dragonbyte-tech.com/member.ph' . 'p?u=1" target="dbtech">Fillip Hannisdal</a>
	', '', 'top', NULL, false);
	
	/*
	print_label_row('<b>' . $vbphrase['special_thanks_and_contributions'] . '</b>', '
		<a href="http://www.darkhandofvalor.com/" target="dbtech">Troy Jones</a>,
		Ciandi Patry,
		<a href="http://www.halforums.com/">David Nihsen</a>
	', '', 'top', NULL, false);
	*/
	/*
	print_label_row('<b>' . $vbphrase['copyright_enforcement_by'] . '</b>', '
		<a href="http://www.vbulletin.com/" target="dbtech">vBulletin Solutions, Inc.</a>
	', '', 'top', NULL, false);
	*/
	print_table_footer();

	print_cp_footer();

}

if (!empty($_REQUEST['do']))
{
	// Strip invalid characters
	$action = preg_replace("/[^a-zA-Z0-9-_]/", "", $_REQUEST['do']);

	if (!file_exists(DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php'))
	{
		if (!file_exists(DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php'))
		{
			// Throw error from invalid action
			print_cp_message(
				$vbphrase['dbtech_dbseo_invalid_action'] . '<br />
				<strong>Not Found:</strong> <em>' . DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php' . '</em><br />' . '
				<strong>Not Found:</strong> <em>' . DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php' . '</em>'
			);
		}
		else
		{
			// Include the selected file
			include(DIR . '/dbtech/dbseo_pro/actions/admin/' . $action . '.php');
		}
	}
	else
	{
		// Include the selected file
		include(DIR . '/dbtech/dbseo/actions/admin/' . $action . '.php');
	}
	print_cp_footer();
}